package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStudiosRequest(marker: Option[Marker] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudiosRequest = {
    import ListStudiosRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudiosRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudiosRequest.ReadOnly =
    zio.aws.emr.model.ListStudiosRequest.wrap(buildAwsValue())
}
object ListStudiosRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudiosRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudiosRequest =
      zio.aws.emr.model.ListStudiosRequest(marker.map(value => value))
    def marker: Option[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosRequest
  ) extends zio.aws.emr.model.ListStudiosRequest.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosRequest
  ): zio.aws.emr.model.ListStudiosRequest.ReadOnly = new Wrapper(impl)
}
