package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SessionMappingDetail(
    studioId: Option[XmlStringMaxLen256] = None,
    identityId: Option[XmlStringMaxLen256] = None,
    identityName: Option[XmlStringMaxLen256] = None,
    identityType: Option[zio.aws.emr.model.IdentityType] = None,
    sessionPolicyArn: Option[XmlStringMaxLen256] = None,
    creationTime: Option[Date] = None,
    lastModifiedTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SessionMappingDetail = {
    import SessionMappingDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SessionMappingDetail
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        identityId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityId)
      .optionallyWith(
        identityName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityName)
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        sessionPolicyArn.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.sessionPolicyArn)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastModifiedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SessionMappingDetail.ReadOnly =
    zio.aws.emr.model.SessionMappingDetail.wrap(buildAwsValue())
}
object SessionMappingDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SessionMappingDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SessionMappingDetail =
      zio.aws.emr.model.SessionMappingDetail(
        studioId.map(value => value),
        identityId.map(value => value),
        identityName.map(value => value),
        identityType.map(value => value),
        sessionPolicyArn.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def studioId: Option[XmlStringMaxLen256]
    def identityId: Option[XmlStringMaxLen256]
    def identityName: Option[XmlStringMaxLen256]
    def identityType: Option[zio.aws.emr.model.IdentityType]
    def sessionPolicyArn: Option[XmlStringMaxLen256]
    def creationTime: Option[Date]
    def lastModifiedTime: Option[Date]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getIdentityId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getIdentityName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getIdentityType: ZIO[Any, AwsError, zio.aws.emr.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getSessionPolicyArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("sessionPolicyArn", sessionPolicyArn)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SessionMappingDetail
  ) extends zio.aws.emr.model.SessionMappingDetail.ReadOnly {
    override val studioId: Option[XmlStringMaxLen256] = scala
      .Option(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityId: Option[XmlStringMaxLen256] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityName: Option[XmlStringMaxLen256] = scala
      .Option(impl.identityName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityType: Option[zio.aws.emr.model.IdentityType] = scala
      .Option(impl.identityType())
      .map(value => zio.aws.emr.model.IdentityType.wrap(value))
    override val sessionPolicyArn: Option[XmlStringMaxLen256] = scala
      .Option(impl.sessionPolicyArn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val lastModifiedTime: Option[Date] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SessionMappingDetail
  ): zio.aws.emr.model.SessionMappingDetail.ReadOnly = new Wrapper(impl)
}
