package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SimpleScalingPolicyConfiguration(
    adjustmentType: Option[zio.aws.emr.model.AdjustmentType] = None,
    scalingAdjustment: Integer,
    coolDown: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration = {
    import SimpleScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration
      .builder()
      .optionallyWith(adjustmentType.map(value => value.unwrap))(
        _.adjustmentType
      )
      .scalingAdjustment(Integer.unwrap(scalingAdjustment): java.lang.Integer)
      .optionallyWith(
        coolDown.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.coolDown)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly =
    zio.aws.emr.model.SimpleScalingPolicyConfiguration.wrap(buildAwsValue())
}
object SimpleScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SimpleScalingPolicyConfiguration =
      zio.aws.emr.model.SimpleScalingPolicyConfiguration(
        adjustmentType.map(value => value),
        scalingAdjustment,
        coolDown.map(value => value)
      )
    def adjustmentType: Option[zio.aws.emr.model.AdjustmentType]
    def scalingAdjustment: Integer
    def coolDown: Option[Integer]
    def getAdjustmentType
        : ZIO[Any, AwsError, zio.aws.emr.model.AdjustmentType] =
      AwsError.unwrapOptionField("adjustmentType", adjustmentType)
    def getScalingAdjustment: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(scalingAdjustment)
    def getCoolDown: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("coolDown", coolDown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration
  ) extends zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly {
    override val adjustmentType: Option[zio.aws.emr.model.AdjustmentType] =
      scala
        .Option(impl.adjustmentType())
        .map(value => zio.aws.emr.model.AdjustmentType.wrap(value))
    override val scalingAdjustment: Integer =
      zio.aws.emr.model.primitives.Integer(impl.scalingAdjustment())
    override val coolDown: Option[Integer] = scala
      .Option(impl.coolDown())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration
  ): zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
