package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StepStateChangeReason(
    code: Option[zio.aws.emr.model.StepStateChangeReasonCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StepStateChangeReason = {
    import StepStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepStateChangeReason.ReadOnly =
    zio.aws.emr.model.StepStateChangeReason.wrap(buildAwsValue())
}
object StepStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepStateChangeReason =
      zio.aws.emr.model.StepStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.emr.model.StepStateChangeReasonCode]
    def message: Option[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.emr.model.StepStateChangeReasonCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ) extends zio.aws.emr.model.StepStateChangeReason.ReadOnly {
    override val code: Option[zio.aws.emr.model.StepStateChangeReasonCode] =
      scala
        .Option(impl.code())
        .map(value => zio.aws.emr.model.StepStateChangeReasonCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ): zio.aws.emr.model.StepStateChangeReason.ReadOnly = new Wrapper(impl)
}
