package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ActionOnFailure {
  def unwrap: software.amazon.awssdk.services.emr.model.ActionOnFailure
}
object ActionOnFailure {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ActionOnFailure
  ): zio.aws.emr.model.ActionOnFailure = value match {
    case software.amazon.awssdk.services.emr.model.ActionOnFailure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ActionOnFailure.TERMINATE_JOB_FLOW =>
      val r = TERMINATE_JOB_FLOW
      r
    case software.amazon.awssdk.services.emr.model.ActionOnFailure.TERMINATE_CLUSTER =>
      val r = TERMINATE_CLUSTER
      r
    case software.amazon.awssdk.services.emr.model.ActionOnFailure.CANCEL_AND_WAIT =>
      val r = CANCEL_AND_WAIT
      r
    case software.amazon.awssdk.services.emr.model.ActionOnFailure.CONTINUE =>
      val r = CONTINUE
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.ActionOnFailure {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ActionOnFailure =
      software.amazon.awssdk.services.emr.model.ActionOnFailure.UNKNOWN_TO_SDK_VERSION
  }
  case object TERMINATE_JOB_FLOW extends zio.aws.emr.model.ActionOnFailure {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ActionOnFailure =
      software.amazon.awssdk.services.emr.model.ActionOnFailure.TERMINATE_JOB_FLOW
  }
  case object TERMINATE_CLUSTER extends zio.aws.emr.model.ActionOnFailure {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ActionOnFailure =
      software.amazon.awssdk.services.emr.model.ActionOnFailure.TERMINATE_CLUSTER
  }
  case object CANCEL_AND_WAIT extends zio.aws.emr.model.ActionOnFailure {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ActionOnFailure =
      software.amazon.awssdk.services.emr.model.ActionOnFailure.CANCEL_AND_WAIT
  }
  case object CONTINUE extends zio.aws.emr.model.ActionOnFailure {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ActionOnFailure =
      software.amazon.awssdk.services.emr.model.ActionOnFailure.CONTINUE
  }
}
