package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Application(
    name: Option[String] = None,
    version: Option[String] = None,
    args: Option[Iterable[String]] = None,
    additionalInfo: Option[Map[String, String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Application
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .optionallyWith(
        additionalInfo.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalInfo)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Application.ReadOnly =
    zio.aws.emr.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Application] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Application =
      zio.aws.emr.model.Application(
        name.map(value => value),
        version.map(value => value),
        args.map(value => value),
        additionalInfo.map(value => value)
      )
    def name: Option[String]
    def version: Option[String]
    def args: Option[List[String]]
    def additionalInfo: Option[Map[String, String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
    def getAdditionalInfo: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Application
  ) extends zio.aws.emr.model.Application.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val args: Option[List[String]] = scala
      .Option(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val additionalInfo: Option[Map[String, String]] = scala
      .Option(impl.additionalInfo())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Application
  ): zio.aws.emr.model.Application.ReadOnly = new Wrapper(impl)
}
