package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClusterResponse(
    cluster: Option[zio.aws.emr.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeClusterResponse.ReadOnly =
    zio.aws.emr.model.DescribeClusterResponse.wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeClusterResponse =
      zio.aws.emr.model
        .DescribeClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.emr.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.emr.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeClusterResponse
  ) extends zio.aws.emr.model.DescribeClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.emr.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.emr.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeClusterResponse
  ): zio.aws.emr.model.DescribeClusterResponse.ReadOnly = new Wrapper(impl)
}
