package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetManagedScalingPolicyRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest = {
    import GetManagedScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetManagedScalingPolicyRequest.ReadOnly =
    zio.aws.emr.model.GetManagedScalingPolicyRequest.wrap(buildAwsValue())
}
object GetManagedScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetManagedScalingPolicyRequest =
      zio.aws.emr.model.GetManagedScalingPolicyRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest
  ) extends zio.aws.emr.model.GetManagedScalingPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest
  ): zio.aws.emr.model.GetManagedScalingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
