package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.{
  WholeNumber,
  XmlStringMaxLen256,
  InstanceFleetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleet(
    id: Option[InstanceFleetId] = None,
    name: Option[XmlStringMaxLen256] = None,
    status: Option[zio.aws.emr.model.InstanceFleetStatus] = None,
    instanceFleetType: Option[zio.aws.emr.model.InstanceFleetType] = None,
    targetOnDemandCapacity: Option[WholeNumber] = None,
    targetSpotCapacity: Option[WholeNumber] = None,
    provisionedOnDemandCapacity: Option[WholeNumber] = None,
    provisionedSpotCapacity: Option[WholeNumber] = None,
    instanceTypeSpecifications: Option[
      Iterable[zio.aws.emr.model.InstanceTypeSpecification]
    ] = None,
    launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleet = {
    import InstanceFleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleet
      .builder()
      .optionallyWith(
        id.map(value => InstanceFleetId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(instanceFleetType.map(value => value.unwrap))(
        _.instanceFleetType
      )
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .optionallyWith(
        provisionedOnDemandCapacity.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.provisionedOnDemandCapacity)
      .optionallyWith(
        provisionedSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.provisionedSpotCapacity)
      .optionallyWith(
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeSpecifications)
      .optionallyWith(launchSpecifications.map(value => value.buildAwsValue()))(
        _.launchSpecifications
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleet.ReadOnly =
    zio.aws.emr.model.InstanceFleet.wrap(buildAwsValue())
}
object InstanceFleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.InstanceFleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleet =
      zio.aws.emr.model.InstanceFleet(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value.asEditable),
        instanceFleetType.map(value => value),
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value),
        provisionedOnDemandCapacity.map(value => value),
        provisionedSpotCapacity.map(value => value),
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchSpecifications.map(value => value.asEditable)
      )
    def id: Option[InstanceFleetId]
    def name: Option[XmlStringMaxLen256]
    def status: Option[zio.aws.emr.model.InstanceFleetStatus.ReadOnly]
    def instanceFleetType: Option[zio.aws.emr.model.InstanceFleetType]
    def targetOnDemandCapacity: Option[WholeNumber]
    def targetSpotCapacity: Option[WholeNumber]
    def provisionedOnDemandCapacity: Option[WholeNumber]
    def provisionedSpotCapacity: Option[WholeNumber]
    def instanceTypeSpecifications
        : Option[List[zio.aws.emr.model.InstanceTypeSpecification.ReadOnly]]
    def launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getInstanceFleetType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetType] =
      AwsError.unwrapOptionField("instanceFleetType", instanceFleetType)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
    def getProvisionedOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField(
        "provisionedOnDemandCapacity",
        provisionedOnDemandCapacity
      )
    def getProvisionedSpotCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("provisionedSpotCapacity", provisionedSpotCapacity)
    def getInstanceTypeSpecifications: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceTypeSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceTypeSpecifications",
      instanceTypeSpecifications
    )
    def getLaunchSpecifications: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleet
  ) extends zio.aws.emr.model.InstanceFleet.ReadOnly {
    override val id: Option[InstanceFleetId] = scala
      .Option(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status
        : Option[zio.aws.emr.model.InstanceFleetStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.emr.model.InstanceFleetStatus.wrap(value))
    override val instanceFleetType
        : Option[zio.aws.emr.model.InstanceFleetType] = scala
      .Option(impl.instanceFleetType())
      .map(value => zio.aws.emr.model.InstanceFleetType.wrap(value))
    override val targetOnDemandCapacity: Option[WholeNumber] = scala
      .Option(impl.targetOnDemandCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Option[WholeNumber] = scala
      .Option(impl.targetSpotCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val provisionedOnDemandCapacity: Option[WholeNumber] = scala
      .Option(impl.provisionedOnDemandCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val provisionedSpotCapacity: Option[WholeNumber] = scala
      .Option(impl.provisionedSpotCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val instanceTypeSpecifications
        : Option[List[zio.aws.emr.model.InstanceTypeSpecification.ReadOnly]] =
      scala
        .Option(impl.instanceTypeSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceTypeSpecification.wrap(item)
          }.toList
        )
    override val launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = scala
      .Option(impl.launchSpecifications())
      .map(value =>
        zio.aws.emr.model.InstanceFleetProvisioningSpecifications.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleet
  ): zio.aws.emr.model.InstanceFleet.ReadOnly = new Wrapper(impl)
}
