package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceGroupState {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceGroupState
}
object InstanceGroupState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceGroupState
  ): zio.aws.emr.model.InstanceGroupState = value match {
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.BOOTSTRAPPING =>
      val r = BOOTSTRAPPING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.RECONFIGURING =>
      val r = RECONFIGURING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.RESIZING =>
      val r = RESIZING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.ARRESTED =>
      val r = ARRESTED
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.SHUTTING_DOWN =>
      val r = SHUTTING_DOWN
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupState.ENDED =>
      val r = ENDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.PROVISIONING
  }
  case object BOOTSTRAPPING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.BOOTSTRAPPING
  }
  case object RUNNING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.RUNNING
  }
  case object RECONFIGURING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.RECONFIGURING
  }
  case object RESIZING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.RESIZING
  }
  case object SUSPENDED extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.SUSPENDED
  }
  case object TERMINATING extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.TERMINATING
  }
  case object TERMINATED extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.TERMINATED
  }
  case object ARRESTED extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.ARRESTED
  }
  case object SHUTTING_DOWN extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.SHUTTING_DOWN
  }
  case object ENDED extends zio.aws.emr.model.InstanceGroupState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupState =
      software.amazon.awssdk.services.emr.model.InstanceGroupState.ENDED
  }
}
