package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSecurityConfigurationsResponse(
    securityConfigurations: Option[
      Iterable[zio.aws.emr.model.SecurityConfigurationSummary]
    ] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse = {
    import ListSecurityConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse
      .builder()
      .optionallyWith(
        securityConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityConfigurations)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly =
    zio.aws.emr.model.ListSecurityConfigurationsResponse.wrap(buildAwsValue())
}
object ListSecurityConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListSecurityConfigurationsResponse =
      zio.aws.emr.model.ListSecurityConfigurationsResponse(
        securityConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def securityConfigurations
        : Option[List[zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly]]
    def marker: Option[Marker]
    def getSecurityConfigurations: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityConfigurations",
      securityConfigurations
    )
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse
  ) extends zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly {
    override val securityConfigurations: Option[
      List[zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly]
    ] = scala
      .Option(impl.securityConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.SecurityConfigurationSummary.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse
  ): zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
