package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Integer, XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunJobFlowRequest(
    name: XmlStringMaxLen256,
    logUri: Option[XmlString] = None,
    logEncryptionKmsKeyId: Option[XmlString] = None,
    additionalInfo: Option[XmlString] = None,
    amiVersion: Option[XmlStringMaxLen256] = None,
    releaseLabel: Option[XmlStringMaxLen256] = None,
    instances: zio.aws.emr.model.JobFlowInstancesConfig,
    steps: Option[Iterable[zio.aws.emr.model.StepConfig]] = None,
    bootstrapActions: Option[
      Iterable[zio.aws.emr.model.BootstrapActionConfig]
    ] = None,
    supportedProducts: Option[Iterable[XmlStringMaxLen256]] = None,
    newSupportedProducts: Option[
      Iterable[zio.aws.emr.model.SupportedProductConfig]
    ] = None,
    applications: Option[Iterable[zio.aws.emr.model.Application]] = None,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None,
    visibleToAllUsers: Option[Boolean] = None,
    jobFlowRole: Option[XmlString] = None,
    serviceRole: Option[XmlString] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None,
    securityConfiguration: Option[XmlString] = None,
    autoScalingRole: Option[XmlString] = None,
    scaleDownBehavior: Option[zio.aws.emr.model.ScaleDownBehavior] = None,
    customAmiId: Option[XmlStringMaxLen256] = None,
    ebsRootVolumeSize: Option[Integer] = None,
    repoUpgradeOnBoot: Option[zio.aws.emr.model.RepoUpgradeOnBoot] = None,
    kerberosAttributes: Option[zio.aws.emr.model.KerberosAttributes] = None,
    stepConcurrencyLevel: Option[Integer] = None,
    managedScalingPolicy: Option[zio.aws.emr.model.ManagedScalingPolicy] = None,
    placementGroupConfigs: Option[
      Iterable[zio.aws.emr.model.PlacementGroupConfig]
    ] = None,
    autoTerminationPolicy: Option[zio.aws.emr.model.AutoTerminationPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RunJobFlowRequest = {
    import RunJobFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RunJobFlowRequest
      .builder()
      .name(XmlStringMaxLen256.unwrap(name): java.lang.String)
      .optionallyWith(
        logUri.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        logEncryptionKmsKeyId.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.logEncryptionKmsKeyId)
      .optionallyWith(
        additionalInfo.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.additionalInfo)
      .optionallyWith(
        amiVersion.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.amiVersion)
      .optionallyWith(
        releaseLabel.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.releaseLabel)
      .instances(instances.buildAwsValue())
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        bootstrapActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bootstrapActions)
      .optionallyWith(
        supportedProducts.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedProducts)
      .optionallyWith(
        newSupportedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.newSupportedProducts)
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(visibleToAllUsers.map(value => value: java.lang.Boolean))(
        _.visibleToAllUsers
      )
      .optionallyWith(
        jobFlowRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.jobFlowRole)
      .optionallyWith(
        serviceRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        securityConfiguration.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.securityConfiguration)
      .optionallyWith(
        autoScalingRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.autoScalingRole)
      .optionallyWith(scaleDownBehavior.map(value => value.unwrap))(
        _.scaleDownBehavior
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(
        ebsRootVolumeSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ebsRootVolumeSize)
      .optionallyWith(repoUpgradeOnBoot.map(value => value.unwrap))(
        _.repoUpgradeOnBoot
      )
      .optionallyWith(kerberosAttributes.map(value => value.buildAwsValue()))(
        _.kerberosAttributes
      )
      .optionallyWith(
        stepConcurrencyLevel.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.stepConcurrencyLevel)
      .optionallyWith(managedScalingPolicy.map(value => value.buildAwsValue()))(
        _.managedScalingPolicy
      )
      .optionallyWith(
        placementGroupConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementGroupConfigs)
      .optionallyWith(
        autoTerminationPolicy.map(value => value.buildAwsValue())
      )(_.autoTerminationPolicy)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RunJobFlowRequest.ReadOnly =
    zio.aws.emr.model.RunJobFlowRequest.wrap(buildAwsValue())
}
object RunJobFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RunJobFlowRequest =
      zio.aws.emr.model.RunJobFlowRequest(
        name,
        logUri.map(value => value),
        logEncryptionKmsKeyId.map(value => value),
        additionalInfo.map(value => value),
        amiVersion.map(value => value),
        releaseLabel.map(value => value),
        instances.asEditable,
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bootstrapActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedProducts.map(value => value),
        newSupportedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibleToAllUsers.map(value => value),
        jobFlowRole.map(value => value),
        serviceRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityConfiguration.map(value => value),
        autoScalingRole.map(value => value),
        scaleDownBehavior.map(value => value),
        customAmiId.map(value => value),
        ebsRootVolumeSize.map(value => value),
        repoUpgradeOnBoot.map(value => value),
        kerberosAttributes.map(value => value.asEditable),
        stepConcurrencyLevel.map(value => value),
        managedScalingPolicy.map(value => value.asEditable),
        placementGroupConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoTerminationPolicy.map(value => value.asEditable)
      )
    def name: XmlStringMaxLen256
    def logUri: Option[XmlString]
    def logEncryptionKmsKeyId: Option[XmlString]
    def additionalInfo: Option[XmlString]
    def amiVersion: Option[XmlStringMaxLen256]
    def releaseLabel: Option[XmlStringMaxLen256]
    def instances: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly
    def steps: Option[List[zio.aws.emr.model.StepConfig.ReadOnly]]
    def bootstrapActions
        : Option[List[zio.aws.emr.model.BootstrapActionConfig.ReadOnly]]
    def supportedProducts: Option[List[XmlStringMaxLen256]]
    def newSupportedProducts
        : Option[List[zio.aws.emr.model.SupportedProductConfig.ReadOnly]]
    def applications: Option[List[zio.aws.emr.model.Application.ReadOnly]]
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def visibleToAllUsers: Option[Boolean]
    def jobFlowRole: Option[XmlString]
    def serviceRole: Option[XmlString]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def securityConfiguration: Option[XmlString]
    def autoScalingRole: Option[XmlString]
    def scaleDownBehavior: Option[zio.aws.emr.model.ScaleDownBehavior]
    def customAmiId: Option[XmlStringMaxLen256]
    def ebsRootVolumeSize: Option[Integer]
    def repoUpgradeOnBoot: Option[zio.aws.emr.model.RepoUpgradeOnBoot]
    def kerberosAttributes
        : Option[zio.aws.emr.model.KerberosAttributes.ReadOnly]
    def stepConcurrencyLevel: Option[Integer]
    def managedScalingPolicy
        : Option[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly]
    def placementGroupConfigs
        : Option[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]]
    def autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly]
    def getName: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(name)
    def getLogUri: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getLogEncryptionKmsKeyId: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("logEncryptionKmsKeyId", logEncryptionKmsKeyId)
    def getAdditionalInfo: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getAmiVersion: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("amiVersion", amiVersion)
    def getReleaseLabel: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getInstances
        : ZIO[Any, Nothing, zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly] =
      ZIO.succeed(instances)
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.emr.model.StepConfig.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
    def getBootstrapActions: ZIO[Any, AwsError, List[
      zio.aws.emr.model.BootstrapActionConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("bootstrapActions", bootstrapActions)
    def getSupportedProducts: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("supportedProducts", supportedProducts)
    def getNewSupportedProducts: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SupportedProductConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("newSupportedProducts", newSupportedProducts)
    def getApplications
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Application.ReadOnly]] =
      AwsError.unwrapOptionField("applications", applications)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getVisibleToAllUsers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("visibleToAllUsers", visibleToAllUsers)
    def getJobFlowRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("jobFlowRole", jobFlowRole)
    def getServiceRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityConfiguration: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("securityConfiguration", securityConfiguration)
    def getAutoScalingRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("autoScalingRole", autoScalingRole)
    def getScaleDownBehavior
        : ZIO[Any, AwsError, zio.aws.emr.model.ScaleDownBehavior] =
      AwsError.unwrapOptionField("scaleDownBehavior", scaleDownBehavior)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getEbsRootVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeSize", ebsRootVolumeSize)
    def getRepoUpgradeOnBoot
        : ZIO[Any, AwsError, zio.aws.emr.model.RepoUpgradeOnBoot] =
      AwsError.unwrapOptionField("repoUpgradeOnBoot", repoUpgradeOnBoot)
    def getKerberosAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      AwsError.unwrapOptionField("kerberosAttributes", kerberosAttributes)
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
    def getManagedScalingPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      AwsError.unwrapOptionField("managedScalingPolicy", managedScalingPolicy)
    def getPlacementGroupConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.PlacementGroupConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementGroupConfigs", placementGroupConfigs)
    def getAutoTerminationPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoTerminationPolicy", autoTerminationPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ) extends zio.aws.emr.model.RunJobFlowRequest.ReadOnly {
    override val name: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.name())
    override val logUri: Option[XmlString] = scala
      .Option(impl.logUri())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val logEncryptionKmsKeyId: Option[XmlString] = scala
      .Option(impl.logEncryptionKmsKeyId())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val additionalInfo: Option[XmlString] = scala
      .Option(impl.additionalInfo())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val amiVersion: Option[XmlStringMaxLen256] = scala
      .Option(impl.amiVersion())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val releaseLabel: Option[XmlStringMaxLen256] = scala
      .Option(impl.releaseLabel())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instances: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly =
      zio.aws.emr.model.JobFlowInstancesConfig.wrap(impl.instances())
    override val steps: Option[List[zio.aws.emr.model.StepConfig.ReadOnly]] =
      scala
        .Option(impl.steps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.StepConfig.wrap(item)
          }.toList
        )
    override val bootstrapActions
        : Option[List[zio.aws.emr.model.BootstrapActionConfig.ReadOnly]] = scala
      .Option(impl.bootstrapActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.BootstrapActionConfig.wrap(item)
        }.toList
      )
    override val supportedProducts: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.supportedProducts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val newSupportedProducts
        : Option[List[zio.aws.emr.model.SupportedProductConfig.ReadOnly]] =
      scala
        .Option(impl.newSupportedProducts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.SupportedProductConfig.wrap(item)
          }.toList
        )
    override val applications
        : Option[List[zio.aws.emr.model.Application.ReadOnly]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Application.wrap(item)
        }.toList
      )
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val visibleToAllUsers: Option[Boolean] =
      scala.Option(impl.visibleToAllUsers()).map(value => value: Boolean)
    override val jobFlowRole: Option[XmlString] = scala
      .Option(impl.jobFlowRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val serviceRole: Option[XmlString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
    override val securityConfiguration: Option[XmlString] = scala
      .Option(impl.securityConfiguration())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val autoScalingRole: Option[XmlString] = scala
      .Option(impl.autoScalingRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val scaleDownBehavior
        : Option[zio.aws.emr.model.ScaleDownBehavior] = scala
      .Option(impl.scaleDownBehavior())
      .map(value => zio.aws.emr.model.ScaleDownBehavior.wrap(value))
    override val customAmiId: Option[XmlStringMaxLen256] = scala
      .Option(impl.customAmiId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ebsRootVolumeSize: Option[Integer] = scala
      .Option(impl.ebsRootVolumeSize())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val repoUpgradeOnBoot
        : Option[zio.aws.emr.model.RepoUpgradeOnBoot] = scala
      .Option(impl.repoUpgradeOnBoot())
      .map(value => zio.aws.emr.model.RepoUpgradeOnBoot.wrap(value))
    override val kerberosAttributes
        : Option[zio.aws.emr.model.KerberosAttributes.ReadOnly] = scala
      .Option(impl.kerberosAttributes())
      .map(value => zio.aws.emr.model.KerberosAttributes.wrap(value))
    override val stepConcurrencyLevel: Option[Integer] = scala
      .Option(impl.stepConcurrencyLevel())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val managedScalingPolicy
        : Option[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] = scala
      .Option(impl.managedScalingPolicy())
      .map(value => zio.aws.emr.model.ManagedScalingPolicy.wrap(value))
    override val placementGroupConfigs
        : Option[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]] = scala
      .Option(impl.placementGroupConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.PlacementGroupConfig.wrap(item)
        }.toList
      )
    override val autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] = scala
      .Option(impl.autoTerminationPolicy())
      .map(value => zio.aws.emr.model.AutoTerminationPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ): zio.aws.emr.model.RunJobFlowRequest.ReadOnly = new Wrapper(impl)
}
