package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait SpotProvisioningTimeoutAction {
  def unwrap
      : software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction
}
object SpotProvisioningTimeoutAction {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction
  ): zio.aws.emr.model.SpotProvisioningTimeoutAction = value match {
    case software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.SWITCH_TO_ON_DEMAND =>
      val r = SWITCH_TO_ON_DEMAND
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.TERMINATE_CLUSTER =>
      val r = TERMINATE_CLUSTER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.SpotProvisioningTimeoutAction {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction =
      software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.UNKNOWN_TO_SDK_VERSION
  }
  case object SWITCH_TO_ON_DEMAND
      extends zio.aws.emr.model.SpotProvisioningTimeoutAction {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction =
      software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.SWITCH_TO_ON_DEMAND
  }
  case object TERMINATE_CLUSTER
      extends zio.aws.emr.model.SpotProvisioningTimeoutAction {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction =
      software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction.TERMINATE_CLUSTER
  }
}
