package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddInstanceGroupsResponse(
    jobFlowId: Option[XmlStringMaxLen256] = None,
    instanceGroupIds: Option[Iterable[XmlStringMaxLen256]] = None,
    clusterArn: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse = {
    import AddInstanceGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
      .builder()
      .optionallyWith(
        jobFlowId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.jobFlowId)
      .optionallyWith(
        instanceGroupIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceGroupIds)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly =
    zio.aws.emr.model.AddInstanceGroupsResponse.wrap(buildAwsValue())
}
object AddInstanceGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceGroupsResponse =
      zio.aws.emr.model.AddInstanceGroupsResponse(
        jobFlowId.map(value => value),
        instanceGroupIds.map(value => value),
        clusterArn.map(value => value)
      )
    def jobFlowId: Option[XmlStringMaxLen256]
    def instanceGroupIds: Option[List[XmlStringMaxLen256]]
    def clusterArn: Option[ArnType]
    def getJobFlowId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("jobFlowId", jobFlowId)
    def getInstanceGroupIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("instanceGroupIds", instanceGroupIds)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ) extends zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly {
    override val jobFlowId: Option[XmlStringMaxLen256] = scala
      .Option(impl.jobFlowId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceGroupIds: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.instanceGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val clusterArn: Option[ArnType] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ): zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly = new Wrapper(impl)
}
