package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait CancelStepsRequestStatus {
  def unwrap: software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus
}
object CancelStepsRequestStatus {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus
  ): zio.aws.emr.model.CancelStepsRequestStatus = value match {
    case software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.CancelStepsRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus =
      software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.emr.model.CancelStepsRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus =
      software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.SUBMITTED
  }
  case object FAILED extends zio.aws.emr.model.CancelStepsRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus =
      software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus.FAILED
  }
}
