package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ClusterState {
  def unwrap: software.amazon.awssdk.services.emr.model.ClusterState
}
object ClusterState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ClusterState
  ): zio.aws.emr.model.ClusterState = value match {
    case software.amazon.awssdk.services.emr.model.ClusterState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.BOOTSTRAPPING =>
      val r = BOOTSTRAPPING
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.WAITING =>
      val r = WAITING
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.emr.model.ClusterState.TERMINATED_WITH_ERRORS =>
      val r = TERMINATED_WITH_ERRORS
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.STARTING
  }
  case object BOOTSTRAPPING extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.BOOTSTRAPPING
  }
  case object RUNNING extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.RUNNING
  }
  case object WAITING extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.WAITING
  }
  case object TERMINATING extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.TERMINATING
  }
  case object TERMINATED extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.TERMINATED
  }
  case object TERMINATED_WITH_ERRORS extends zio.aws.emr.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterState =
      software.amazon.awssdk.services.emr.model.ClusterState.TERMINATED_WITH_ERRORS
  }
}
