package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecurityConfigurationRequest(name: XmlString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest = {
    import DescribeSecurityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest
      .builder()
      .name(XmlString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.DescribeSecurityConfigurationRequest.ReadOnly =
    zio.aws.emr.model.DescribeSecurityConfigurationRequest.wrap(buildAwsValue())
}
object DescribeSecurityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeSecurityConfigurationRequest =
      zio.aws.emr.model.DescribeSecurityConfigurationRequest(name)
    def name: XmlString
    def getName: ZIO[Any, Nothing, XmlString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest
  ) extends zio.aws.emr.model.DescribeSecurityConfigurationRequest.ReadOnly {
    override val name: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest
  ): zio.aws.emr.model.DescribeSecurityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
