package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAutoTerminationPolicyResponse(
    autoTerminationPolicy: Option[zio.aws.emr.model.AutoTerminationPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse = {
    import GetAutoTerminationPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse
      .builder()
      .optionallyWith(
        autoTerminationPolicy.map(value => value.buildAwsValue())
      )(_.autoTerminationPolicy)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly =
    zio.aws.emr.model.GetAutoTerminationPolicyResponse.wrap(buildAwsValue())
}
object GetAutoTerminationPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetAutoTerminationPolicyResponse =
      zio.aws.emr.model.GetAutoTerminationPolicyResponse(
        autoTerminationPolicy.map(value => value.asEditable)
      )
    def autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly]
    def getAutoTerminationPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoTerminationPolicy", autoTerminationPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse
  ) extends zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly {
    override val autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] = scala
      .Option(impl.autoTerminationPolicy())
      .map(value => zio.aws.emr.model.AutoTerminationPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse
  ): zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
