package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleetStatus(
    state: Option[zio.aws.emr.model.InstanceFleetState] = None,
    stateChangeReason: Option[
      zio.aws.emr.model.InstanceFleetStateChangeReason
    ] = None,
    timeline: Option[zio.aws.emr.model.InstanceFleetTimeline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetStatus = {
    import InstanceFleetStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetStatus.ReadOnly =
    zio.aws.emr.model.InstanceFleetStatus.wrap(buildAwsValue())
}
object InstanceFleetStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetStatus =
      zio.aws.emr.model.InstanceFleetStatus(
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        timeline.map(value => value.asEditable)
      )
    def state: Option[zio.aws.emr.model.InstanceFleetState]
    def stateChangeReason
        : Option[zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly]
    def timeline: Option[zio.aws.emr.model.InstanceFleetTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetStatus
  ) extends zio.aws.emr.model.InstanceFleetStatus.ReadOnly {
    override val state: Option[zio.aws.emr.model.InstanceFleetState] = scala
      .Option(impl.state())
      .map(value => zio.aws.emr.model.InstanceFleetState.wrap(value))
    override val stateChangeReason
        : Option[zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly] =
      scala
        .Option(impl.stateChangeReason())
        .map(value =>
          zio.aws.emr.model.InstanceFleetStateChangeReason.wrap(value)
        )
    override val timeline
        : Option[zio.aws.emr.model.InstanceFleetTimeline.ReadOnly] = scala
      .Option(impl.timeline())
      .map(value => zio.aws.emr.model.InstanceFleetTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetStatus
  ): zio.aws.emr.model.InstanceFleetStatus.ReadOnly = new Wrapper(impl)
}
