package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyValue(
    key: Option[XmlString] = None,
    value: Option[XmlString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.KeyValue = {
    import KeyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.KeyValue
      .builder()
      .optionallyWith(
        key.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.KeyValue.ReadOnly =
    zio.aws.emr.model.KeyValue.wrap(buildAwsValue())
}
object KeyValue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.KeyValue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.KeyValue = zio.aws.emr.model
      .KeyValue(key.map(value => value), value.map(value => value))
    def key: Option[XmlString]
    def value: Option[XmlString]
    def getKey: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.KeyValue
  ) extends zio.aws.emr.model.KeyValue.ReadOnly {
    override val key: Option[XmlString] = scala
      .Option(impl.key())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val value: Option[XmlString] = scala
      .Option(impl.value())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.KeyValue
  ): zio.aws.emr.model.KeyValue.ReadOnly = new Wrapper(impl)
}
