package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Marker, Date, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ListNotebookExecutionsRequest(
    editorId: Option[XmlStringMaxLen256] = None,
    status: Option[zio.aws.emr.model.NotebookExecutionStatus] = None,
    from: Option[Date] = None,
    to: Option[Date] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest = {
    import ListNotebookExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
      .builder()
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(from.map(value => Date.unwrap(value): Instant))(_.from)
      .optionallyWith(to.map(value => Date.unwrap(value): Instant))(_.to)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly =
    zio.aws.emr.model.ListNotebookExecutionsRequest.wrap(buildAwsValue())
}
object ListNotebookExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListNotebookExecutionsRequest =
      zio.aws.emr.model.ListNotebookExecutionsRequest(
        editorId.map(value => value),
        status.map(value => value),
        from.map(value => value),
        to.map(value => value),
        marker.map(value => value)
      )
    def editorId: Option[XmlStringMaxLen256]
    def status: Option[zio.aws.emr.model.NotebookExecutionStatus]
    def from: Option[Date]
    def to: Option[Date]
    def marker: Option[Marker]
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFrom: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Date] = AwsError.unwrapOptionField("to", to)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ) extends zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly {
    override val editorId: Option[XmlStringMaxLen256] = scala
      .Option(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status: Option[zio.aws.emr.model.NotebookExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val from: Option[Date] = scala
      .Option(impl.from())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val to: Option[Date] = scala
      .Option(impl.to())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ): zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
