package zio.aws.emr.model
import zio.aws.emr.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsRequest(
    resourceId: ResourceId,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RemoveTagsRequest = {
    import RemoveTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RemoveTagsRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RemoveTagsRequest.ReadOnly =
    zio.aws.emr.model.RemoveTagsRequest.wrap(buildAwsValue())
}
object RemoveTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RemoveTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RemoveTagsRequest =
      zio.aws.emr.model.RemoveTagsRequest(resourceId, tagKeys)
    def resourceId: ResourceId
    def tagKeys: List[String]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RemoveTagsRequest
  ) extends zio.aws.emr.model.RemoveTagsRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.emr.model.primitives.ResourceId(impl.resourceId())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RemoveTagsRequest
  ): zio.aws.emr.model.RemoveTagsRequest.ReadOnly = new Wrapper(impl)
}
