package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ShrinkPolicy(
    decommissionTimeout: Option[Integer] = None,
    instanceResizePolicy: Option[zio.aws.emr.model.InstanceResizePolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ShrinkPolicy = {
    import ShrinkPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ShrinkPolicy
      .builder()
      .optionallyWith(
        decommissionTimeout.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.decommissionTimeout)
      .optionallyWith(instanceResizePolicy.map(value => value.buildAwsValue()))(
        _.instanceResizePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ShrinkPolicy.ReadOnly =
    zio.aws.emr.model.ShrinkPolicy.wrap(buildAwsValue())
}
object ShrinkPolicy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ShrinkPolicy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ShrinkPolicy =
      zio.aws.emr.model.ShrinkPolicy(
        decommissionTimeout.map(value => value),
        instanceResizePolicy.map(value => value.asEditable)
      )
    def decommissionTimeout: Option[Integer]
    def instanceResizePolicy
        : Option[zio.aws.emr.model.InstanceResizePolicy.ReadOnly]
    def getDecommissionTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("decommissionTimeout", decommissionTimeout)
    def getInstanceResizePolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceResizePolicy.ReadOnly] =
      AwsError.unwrapOptionField("instanceResizePolicy", instanceResizePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ShrinkPolicy
  ) extends zio.aws.emr.model.ShrinkPolicy.ReadOnly {
    override val decommissionTimeout: Option[Integer] = scala
      .Option(impl.decommissionTimeout())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val instanceResizePolicy
        : Option[zio.aws.emr.model.InstanceResizePolicy.ReadOnly] = scala
      .Option(impl.instanceResizePolicy())
      .map(value => zio.aws.emr.model.InstanceResizePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ShrinkPolicy
  ): zio.aws.emr.model.ShrinkPolicy.ReadOnly = new Wrapper(impl)
}
