package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Application(
    name: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    args: Optional[Iterable[String]] = Optional.Absent,
    additionalInfo: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Application
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .optionallyWith(
        additionalInfo.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalInfo)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Application.ReadOnly =
    zio.aws.emr.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Application] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Application =
      zio.aws.emr.model.Application(
        name.map(value => value),
        version.map(value => value),
        args.map(value => value),
        additionalInfo.map(value => value)
      )
    def name: Optional[String]
    def version: Optional[String]
    def args: Optional[List[String]]
    def additionalInfo: Optional[Map[String, String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
    def getAdditionalInfo: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Application
  ) extends zio.aws.emr.model.Application.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val args: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val additionalInfo: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalInfo())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Application
  ): zio.aws.emr.model.Application.ReadOnly = new Wrapper(impl)
}
