package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicy(
    constraints: zio.aws.emr.model.ScalingConstraints,
    rules: Iterable[zio.aws.emr.model.ScalingRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoScalingPolicy = {
    import AutoScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoScalingPolicy
      .builder()
      .constraints(constraints.buildAwsValue())
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AutoScalingPolicy.ReadOnly =
    zio.aws.emr.model.AutoScalingPolicy.wrap(buildAwsValue())
}
object AutoScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoScalingPolicy =
      zio.aws.emr.model.AutoScalingPolicy(
        constraints.asEditable,
        rules.map { item =>
          item.asEditable
        }
      )
    def constraints: zio.aws.emr.model.ScalingConstraints.ReadOnly
    def rules: List[zio.aws.emr.model.ScalingRule.ReadOnly]
    def getConstraints
        : ZIO[Any, Nothing, zio.aws.emr.model.ScalingConstraints.ReadOnly] =
      ZIO.succeed(constraints)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.emr.model.ScalingRule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicy
  ) extends zio.aws.emr.model.AutoScalingPolicy.ReadOnly {
    override val constraints: zio.aws.emr.model.ScalingConstraints.ReadOnly =
      zio.aws.emr.model.ScalingConstraints.wrap(impl.constraints())
    override val rules: List[zio.aws.emr.model.ScalingRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.emr.model.ScalingRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicy
  ): zio.aws.emr.model.AutoScalingPolicy.ReadOnly = new Wrapper(impl)
}
