package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicyStateChangeReason(
    code: Optional[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason = {
    import AutoScalingPolicyStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly =
    zio.aws.emr.model.AutoScalingPolicyStateChangeReason.wrap(buildAwsValue())
}
object AutoScalingPolicyStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoScalingPolicyStateChangeReason =
      zio.aws.emr.model.AutoScalingPolicyStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ) extends zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly {
    override val code
        : Optional[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ): zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly =
    new Wrapper(impl)
}
