package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTerminationPolicy(
    idleTimeout: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoTerminationPolicy = {
    import AutoTerminationPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoTerminationPolicy
      .builder()
      .optionallyWith(idleTimeout.map(value => value: java.lang.Long))(
        _.idleTimeout
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AutoTerminationPolicy.ReadOnly =
    zio.aws.emr.model.AutoTerminationPolicy.wrap(buildAwsValue())
}
object AutoTerminationPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoTerminationPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoTerminationPolicy =
      zio.aws.emr.model.AutoTerminationPolicy(idleTimeout.map(value => value))
    def idleTimeout: Optional[Long]
    def getIdleTimeout: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("idleTimeout", idleTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoTerminationPolicy
  ) extends zio.aws.emr.model.AutoTerminationPolicy.ReadOnly {
    override val idleTimeout: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.idleTimeout())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoTerminationPolicy
  ): zio.aws.emr.model.AutoTerminationPolicy.ReadOnly = new Wrapper(impl)
}
