package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BlockPublicAccessConfiguration(
    blockPublicSecurityGroupRules: Boolean,
    permittedPublicSecurityGroupRuleRanges: Optional[
      Iterable[zio.aws.emr.model.PortRange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.BlockPublicAccessConfiguration = {
    import BlockPublicAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.BlockPublicAccessConfiguration
      .builder()
      .blockPublicSecurityGroupRules(
        blockPublicSecurityGroupRules: java.lang.Boolean
      )
      .optionallyWith(
        permittedPublicSecurityGroupRuleRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permittedPublicSecurityGroupRuleRanges)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly =
    zio.aws.emr.model.BlockPublicAccessConfiguration.wrap(buildAwsValue())
}
object BlockPublicAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.BlockPublicAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.BlockPublicAccessConfiguration =
      zio.aws.emr.model.BlockPublicAccessConfiguration(
        blockPublicSecurityGroupRules,
        permittedPublicSecurityGroupRuleRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blockPublicSecurityGroupRules: Boolean
    def permittedPublicSecurityGroupRuleRanges
        : Optional[List[zio.aws.emr.model.PortRange.ReadOnly]]
    def getBlockPublicSecurityGroupRules: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(blockPublicSecurityGroupRules)
    def getPermittedPublicSecurityGroupRuleRanges
        : ZIO[Any, AwsError, List[zio.aws.emr.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField(
        "permittedPublicSecurityGroupRuleRanges",
        permittedPublicSecurityGroupRuleRanges
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.BlockPublicAccessConfiguration
  ) extends zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly {
    override val blockPublicSecurityGroupRules: Boolean =
      impl.blockPublicSecurityGroupRules(): Boolean
    override val permittedPublicSecurityGroupRuleRanges
        : Optional[List[zio.aws.emr.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permittedPublicSecurityGroupRuleRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.PortRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.BlockPublicAccessConfiguration
  ): zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
