package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ClusterStateChangeReasonCode {
  def unwrap
      : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode
}
object ClusterStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode
  ): zio.aws.emr.model.ClusterStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INSTANCE_FAILURE =>
      val r = INSTANCE_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INSTANCE_FLEET_TIMEOUT =>
      val r = INSTANCE_FLEET_TIMEOUT
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.BOOTSTRAP_FAILURE =>
      val r = BOOTSTRAP_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.USER_REQUEST =>
      val r = USER_REQUEST
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.STEP_FAILURE =>
      val r = STEP_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.ALL_STEPS_COMPLETED =>
      val r = ALL_STEPS_COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INTERNAL_ERROR
  }
  case object VALIDATION_ERROR
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.VALIDATION_ERROR
  }
  case object INSTANCE_FAILURE
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INSTANCE_FAILURE
  }
  case object INSTANCE_FLEET_TIMEOUT
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.INSTANCE_FLEET_TIMEOUT
  }
  case object BOOTSTRAP_FAILURE
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.BOOTSTRAP_FAILURE
  }
  case object USER_REQUEST
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.USER_REQUEST
  }
  case object STEP_FAILURE
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.STEP_FAILURE
  }
  case object ALL_STEPS_COMPLETED
      extends zio.aws.emr.model.ClusterStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.ClusterStateChangeReasonCode.ALL_STEPS_COMPLETED
  }
}
