package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Configuration(
    classification: Optional[String] = Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    properties: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Configuration
      .builder()
      .optionallyWith(classification.map(value => value: java.lang.String))(
        _.classification
      )
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Configuration.ReadOnly =
    zio.aws.emr.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Configuration] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Configuration =
      zio.aws.emr.model.Configuration(
        classification.map(value => value),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        properties.map(value => value)
      )
    def classification: Optional[String]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def properties: Optional[Map[String, String]]
    def getClassification: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("classification", classification)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getProperties: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Configuration
  ) extends zio.aws.emr.model.Configuration.ReadOnly {
    override val classification: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.classification())
      .map(value => value: String)
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val properties: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Configuration
  ): zio.aws.emr.model.Configuration.ReadOnly = new Wrapper(impl)
}
