package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateSecurityConfigurationResponse(
    name: XmlString,
    creationDateTime: Date
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse = {
    import CreateSecurityConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse
      .builder()
      .name(XmlString.unwrap(name): java.lang.String)
      .creationDateTime(Date.unwrap(creationDateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly =
    zio.aws.emr.model.CreateSecurityConfigurationResponse.wrap(buildAwsValue())
}
object CreateSecurityConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CreateSecurityConfigurationResponse =
      zio.aws.emr.model
        .CreateSecurityConfigurationResponse(name, creationDateTime)
    def name: XmlString
    def creationDateTime: Date
    def getName: ZIO[Any, Nothing, XmlString] = ZIO.succeed(name)
    def getCreationDateTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse
  ) extends zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly {
    override val name: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.name())
    override val creationDateTime: Date =
      zio.aws.emr.model.primitives.Date(impl.creationDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse
  ): zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
