package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStudioResponse(
    studioId: Optional[XmlStringMaxLen256] = Optional.Absent,
    url: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CreateStudioResponse = {
    import CreateStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CreateStudioResponse
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        url.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CreateStudioResponse.ReadOnly =
    zio.aws.emr.model.CreateStudioResponse.wrap(buildAwsValue())
}
object CreateStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CreateStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CreateStudioResponse =
      zio.aws.emr.model.CreateStudioResponse(
        studioId.map(value => value),
        url.map(value => value)
      )
    def studioId: Optional[XmlStringMaxLen256]
    def url: Optional[XmlString]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CreateStudioResponse
  ) extends zio.aws.emr.model.CreateStudioResponse.ReadOnly {
    override val studioId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val url: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CreateStudioResponse
  ): zio.aws.emr.model.CreateStudioResponse.ReadOnly = new Wrapper(impl)
}
