package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Credentials(
    usernamePassword: Optional[zio.aws.emr.model.UsernamePassword] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Credentials
      .builder()
      .optionallyWith(usernamePassword.map(value => value.buildAwsValue()))(
        _.usernamePassword
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Credentials.ReadOnly =
    zio.aws.emr.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Credentials] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Credentials = zio.aws.emr.model
      .Credentials(usernamePassword.map(value => value.asEditable))
    def usernamePassword: Optional[zio.aws.emr.model.UsernamePassword.ReadOnly]
    def getUsernamePassword
        : ZIO[Any, AwsError, zio.aws.emr.model.UsernamePassword.ReadOnly] =
      AwsError.unwrapOptionField("usernamePassword", usernamePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Credentials
  ) extends zio.aws.emr.model.Credentials.ReadOnly {
    override val usernamePassword
        : Optional[zio.aws.emr.model.UsernamePassword.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usernamePassword())
        .map(value => zio.aws.emr.model.UsernamePassword.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Credentials
  ): zio.aws.emr.model.Credentials.ReadOnly = new Wrapper(impl)
}
