package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSecurityConfigurationRequest(name: XmlString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest = {
    import DeleteSecurityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest
      .builder()
      .name(XmlString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.DeleteSecurityConfigurationRequest.ReadOnly =
    zio.aws.emr.model.DeleteSecurityConfigurationRequest.wrap(buildAwsValue())
}
object DeleteSecurityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DeleteSecurityConfigurationRequest =
      zio.aws.emr.model.DeleteSecurityConfigurationRequest(name)
    def name: XmlString
    def getName: ZIO[Any, Nothing, XmlString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest
  ) extends zio.aws.emr.model.DeleteSecurityConfigurationRequest.ReadOnly {
    override val name: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest
  ): zio.aws.emr.model.DeleteSecurityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
