package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.MaxResultsNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReleaseLabelRequest(
    releaseLabel: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest = {
    import DescribeReleaseLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest
      .builder()
      .optionallyWith(releaseLabel.map(value => value: java.lang.String))(
        _.releaseLabel
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsNumber.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeReleaseLabelRequest.ReadOnly =
    zio.aws.emr.model.DescribeReleaseLabelRequest.wrap(buildAwsValue())
}
object DescribeReleaseLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeReleaseLabelRequest =
      zio.aws.emr.model.DescribeReleaseLabelRequest(
        releaseLabel.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def releaseLabel: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsNumber]
    def getReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsNumber] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest
  ) extends zio.aws.emr.model.DescribeReleaseLabelRequest.ReadOnly {
    override val releaseLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseLabel())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.emr.model.primitives.MaxResultsNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest
  ): zio.aws.emr.model.DescribeReleaseLabelRequest.ReadOnly = new Wrapper(impl)
}
