package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStepResponse(
    step: Optional[zio.aws.emr.model.Step] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeStepResponse = {
    import DescribeStepResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeStepResponse
      .builder()
      .optionallyWith(step.map(value => value.buildAwsValue()))(_.step)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeStepResponse.ReadOnly =
    zio.aws.emr.model.DescribeStepResponse.wrap(buildAwsValue())
}
object DescribeStepResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeStepResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeStepResponse = zio.aws.emr.model
      .DescribeStepResponse(step.map(value => value.asEditable))
    def step: Optional[zio.aws.emr.model.Step.ReadOnly]
    def getStep: ZIO[Any, AwsError, zio.aws.emr.model.Step.ReadOnly] =
      AwsError.unwrapOptionField("step", step)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeStepResponse
  ) extends zio.aws.emr.model.DescribeStepResponse.ReadOnly {
    override val step: Optional[zio.aws.emr.model.Step.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.step())
        .map(value => zio.aws.emr.model.Step.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeStepResponse
  ): zio.aws.emr.model.DescribeStepResponse.ReadOnly = new Wrapper(impl)
}
