package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStudioRequest(studioId: XmlStringMaxLen256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeStudioRequest = {
    import DescribeStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeStudioRequest
      .builder()
      .studioId(XmlStringMaxLen256.unwrap(studioId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeStudioRequest.ReadOnly =
    zio.aws.emr.model.DescribeStudioRequest.wrap(buildAwsValue())
}
object DescribeStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeStudioRequest =
      zio.aws.emr.model.DescribeStudioRequest(studioId)
    def studioId: XmlStringMaxLen256
    def getStudioId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeStudioRequest
  ) extends zio.aws.emr.model.DescribeStudioRequest.ReadOnly {
    override val studioId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.studioId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeStudioRequest
  ): zio.aws.emr.model.DescribeStudioRequest.ReadOnly = new Wrapper(impl)
}
