package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ec2InstanceAttributes(
    ec2KeyName: Optional[String] = Optional.Absent,
    ec2SubnetId: Optional[String] = Optional.Absent,
    requestedEc2SubnetIds: Optional[Iterable[XmlStringMaxLen256]] =
      Optional.Absent,
    ec2AvailabilityZone: Optional[String] = Optional.Absent,
    requestedEc2AvailabilityZones: Optional[Iterable[XmlStringMaxLen256]] =
      Optional.Absent,
    iamInstanceProfile: Optional[String] = Optional.Absent,
    emrManagedMasterSecurityGroup: Optional[String] = Optional.Absent,
    emrManagedSlaveSecurityGroup: Optional[String] = Optional.Absent,
    serviceAccessSecurityGroup: Optional[String] = Optional.Absent,
    additionalMasterSecurityGroups: Optional[Iterable[String]] =
      Optional.Absent,
    additionalSlaveSecurityGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes = {
    import Ec2InstanceAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes
      .builder()
      .optionallyWith(ec2KeyName.map(value => value: java.lang.String))(
        _.ec2KeyName
      )
      .optionallyWith(ec2SubnetId.map(value => value: java.lang.String))(
        _.ec2SubnetId
      )
      .optionallyWith(
        requestedEc2SubnetIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requestedEc2SubnetIds)
      .optionallyWith(
        ec2AvailabilityZone.map(value => value: java.lang.String)
      )(_.ec2AvailabilityZone)
      .optionallyWith(
        requestedEc2AvailabilityZones.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requestedEc2AvailabilityZones)
      .optionallyWith(iamInstanceProfile.map(value => value: java.lang.String))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        emrManagedMasterSecurityGroup.map(value => value: java.lang.String)
      )(_.emrManagedMasterSecurityGroup)
      .optionallyWith(
        emrManagedSlaveSecurityGroup.map(value => value: java.lang.String)
      )(_.emrManagedSlaveSecurityGroup)
      .optionallyWith(
        serviceAccessSecurityGroup.map(value => value: java.lang.String)
      )(_.serviceAccessSecurityGroup)
      .optionallyWith(
        additionalMasterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMasterSecurityGroups)
      .optionallyWith(
        additionalSlaveSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.additionalSlaveSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly =
    zio.aws.emr.model.Ec2InstanceAttributes.wrap(buildAwsValue())
}
object Ec2InstanceAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Ec2InstanceAttributes =
      zio.aws.emr.model.Ec2InstanceAttributes(
        ec2KeyName.map(value => value),
        ec2SubnetId.map(value => value),
        requestedEc2SubnetIds.map(value => value),
        ec2AvailabilityZone.map(value => value),
        requestedEc2AvailabilityZones.map(value => value),
        iamInstanceProfile.map(value => value),
        emrManagedMasterSecurityGroup.map(value => value),
        emrManagedSlaveSecurityGroup.map(value => value),
        serviceAccessSecurityGroup.map(value => value),
        additionalMasterSecurityGroups.map(value => value),
        additionalSlaveSecurityGroups.map(value => value)
      )
    def ec2KeyName: Optional[String]
    def ec2SubnetId: Optional[String]
    def requestedEc2SubnetIds: Optional[List[XmlStringMaxLen256]]
    def ec2AvailabilityZone: Optional[String]
    def requestedEc2AvailabilityZones: Optional[List[XmlStringMaxLen256]]
    def iamInstanceProfile: Optional[String]
    def emrManagedMasterSecurityGroup: Optional[String]
    def emrManagedSlaveSecurityGroup: Optional[String]
    def serviceAccessSecurityGroup: Optional[String]
    def additionalMasterSecurityGroups: Optional[List[String]]
    def additionalSlaveSecurityGroups: Optional[List[String]]
    def getEc2KeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2KeyName", ec2KeyName)
    def getEc2SubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SubnetId", ec2SubnetId)
    def getRequestedEc2SubnetIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("requestedEc2SubnetIds", requestedEc2SubnetIds)
    def getEc2AvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2AvailabilityZone", ec2AvailabilityZone)
    def getRequestedEc2AvailabilityZones
        : ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField(
        "requestedEc2AvailabilityZones",
        requestedEc2AvailabilityZones
      )
    def getIamInstanceProfile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getEmrManagedMasterSecurityGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "emrManagedMasterSecurityGroup",
        emrManagedMasterSecurityGroup
      )
    def getEmrManagedSlaveSecurityGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "emrManagedSlaveSecurityGroup",
        emrManagedSlaveSecurityGroup
      )
    def getServiceAccessSecurityGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serviceAccessSecurityGroup",
        serviceAccessSecurityGroup
      )
    def getAdditionalMasterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "additionalMasterSecurityGroups",
        additionalMasterSecurityGroups
      )
    def getAdditionalSlaveSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "additionalSlaveSecurityGroups",
        additionalSlaveSecurityGroups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes
  ) extends zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly {
    override val ec2KeyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2KeyName())
      .map(value => value: String)
    override val ec2SubnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2SubnetId())
      .map(value => value: String)
    override val requestedEc2SubnetIds: Optional[List[XmlStringMaxLen256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestedEc2SubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
          }.toList
        )
    override val ec2AvailabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2AvailabilityZone())
      .map(value => value: String)
    override val requestedEc2AvailabilityZones
        : Optional[List[XmlStringMaxLen256]] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedEc2AvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val iamInstanceProfile: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfile())
      .map(value => value: String)
    override val emrManagedMasterSecurityGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emrManagedMasterSecurityGroup())
        .map(value => value: String)
    override val emrManagedSlaveSecurityGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emrManagedSlaveSecurityGroup())
        .map(value => value: String)
    override val serviceAccessSecurityGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceAccessSecurityGroup())
        .map(value => value: String)
    override val additionalMasterSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMasterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val additionalSlaveSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalSlaveSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes
  ): zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly = new Wrapper(impl)
}
