package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetClusterSessionCredentialsRequest(
    clusterId: XmlStringMaxLen256,
    executionRoleArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest = {
    import GetClusterSessionCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest
      .builder()
      .clusterId(XmlStringMaxLen256.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        executionRoleArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.GetClusterSessionCredentialsRequest.ReadOnly =
    zio.aws.emr.model.GetClusterSessionCredentialsRequest.wrap(buildAwsValue())
}
object GetClusterSessionCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetClusterSessionCredentialsRequest =
      zio.aws.emr.model.GetClusterSessionCredentialsRequest(
        clusterId,
        executionRoleArn.map(value => value)
      )
    def clusterId: XmlStringMaxLen256
    def executionRoleArn: Optional[ArnType]
    def getClusterId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(clusterId)
    def getExecutionRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest
  ) extends zio.aws.emr.model.GetClusterSessionCredentialsRequest.ReadOnly {
    override val clusterId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.clusterId())
    override val executionRoleArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest
  ): zio.aws.emr.model.GetClusterSessionCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
