package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait IdentityType {
  def unwrap: software.amazon.awssdk.services.emr.model.IdentityType
}
object IdentityType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.IdentityType
  ): zio.aws.emr.model.IdentityType = value match {
    case software.amazon.awssdk.services.emr.model.IdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.IdentityType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.emr.model.IdentityType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.IdentityType =
      software.amazon.awssdk.services.emr.model.IdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.emr.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.IdentityType =
      software.amazon.awssdk.services.emr.model.IdentityType.USER
  }
  case object GROUP extends zio.aws.emr.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.IdentityType =
      software.amazon.awssdk.services.emr.model.IdentityType.GROUP
  }
}
