package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  WholeNumber,
  InstanceFleetId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceFleetModifyConfig(
    instanceFleetId: InstanceFleetId,
    targetOnDemandCapacity: Optional[WholeNumber] = Optional.Absent,
    targetSpotCapacity: Optional[WholeNumber] = Optional.Absent,
    resizeSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetResizingSpecifications
    ] = Optional.Absent,
    instanceTypeConfigs: Optional[
      Iterable[zio.aws.emr.model.InstanceTypeConfig]
    ] = Optional.Absent,
    context: Optional[XmlStringMaxLen256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig = {
    import InstanceFleetModifyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
      .builder()
      .instanceFleetId(
        InstanceFleetId.unwrap(instanceFleetId): java.lang.String
      )
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .optionallyWith(resizeSpecifications.map(value => value.buildAwsValue()))(
        _.resizeSpecifications
      )
      .optionallyWith(
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeConfigs)
      .optionallyWith(
        context.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.context)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly =
    zio.aws.emr.model.InstanceFleetModifyConfig.wrap(buildAwsValue())
}
object InstanceFleetModifyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetModifyConfig =
      zio.aws.emr.model.InstanceFleetModifyConfig(
        instanceFleetId,
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value),
        resizeSpecifications.map(value => value.asEditable),
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        context.map(value => value)
      )
    def instanceFleetId: InstanceFleetId
    def targetOnDemandCapacity: Optional[WholeNumber]
    def targetSpotCapacity: Optional[WholeNumber]
    def resizeSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly
    ]
    def instanceTypeConfigs
        : Optional[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]]
    def context: Optional[XmlStringMaxLen256]
    def getInstanceFleetId: ZIO[Any, Nothing, InstanceFleetId] =
      ZIO.succeed(instanceFleetId)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
    def getResizeSpecifications: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly
    ] = AwsError.unwrapOptionField("resizeSpecifications", resizeSpecifications)
    def getInstanceTypeConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceTypeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypeConfigs", instanceTypeConfigs)
    def getContext: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ) extends zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly {
    override val instanceFleetId: InstanceFleetId =
      zio.aws.emr.model.primitives.InstanceFleetId(impl.instanceFleetId())
    override val targetOnDemandCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetOnDemandCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSpotCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val resizeSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resizeSpecifications())
      .map(value =>
        zio.aws.emr.model.InstanceFleetResizingSpecifications.wrap(value)
      )
    override val instanceTypeConfigs
        : Optional[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypeConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceTypeConfig.wrap(item)
          }.toList
        )
    override val context: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ): zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly = new Wrapper(impl)
}
