package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceFleetResizingSpecifications(
    spotResizeSpecification: Optional[
      zio.aws.emr.model.SpotResizingSpecification
    ] = Optional.Absent,
    onDemandResizeSpecification: Optional[
      zio.aws.emr.model.OnDemandResizingSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications = {
    import InstanceFleetResizingSpecifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications
      .builder()
      .optionallyWith(
        spotResizeSpecification.map(value => value.buildAwsValue())
      )(_.spotResizeSpecification)
      .optionallyWith(
        onDemandResizeSpecification.map(value => value.buildAwsValue())
      )(_.onDemandResizeSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly =
    zio.aws.emr.model.InstanceFleetResizingSpecifications.wrap(buildAwsValue())
}
object InstanceFleetResizingSpecifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetResizingSpecifications =
      zio.aws.emr.model.InstanceFleetResizingSpecifications(
        spotResizeSpecification.map(value => value.asEditable),
        onDemandResizeSpecification.map(value => value.asEditable)
      )
    def spotResizeSpecification
        : Optional[zio.aws.emr.model.SpotResizingSpecification.ReadOnly]
    def onDemandResizeSpecification
        : Optional[zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly]
    def getSpotResizeSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.SpotResizingSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotResizeSpecification",
      spotResizeSpecification
    )
    def getOnDemandResizeSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDemandResizeSpecification",
      onDemandResizeSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications
  ) extends zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly {
    override val spotResizeSpecification
        : Optional[zio.aws.emr.model.SpotResizingSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotResizeSpecification())
        .map(value => zio.aws.emr.model.SpotResizingSpecification.wrap(value))
    override val onDemandResizeSpecification
        : Optional[zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandResizeSpecification())
        .map(value =>
          zio.aws.emr.model.OnDemandResizingSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications
  ): zio.aws.emr.model.InstanceFleetResizingSpecifications.ReadOnly =
    new Wrapper(impl)
}
