package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.Date
import scala.jdk.CollectionConverters._
final case class InstanceFleetTimeline(
    creationDateTime: Optional[Date] = Optional.Absent,
    readyDateTime: Optional[Date] = Optional.Absent,
    endDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetTimeline = {
    import InstanceFleetTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetTimeline
      .builder()
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(readyDateTime.map(value => Date.unwrap(value): Instant))(
        _.readyDateTime
      )
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetTimeline.ReadOnly =
    zio.aws.emr.model.InstanceFleetTimeline.wrap(buildAwsValue())
}
object InstanceFleetTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetTimeline =
      zio.aws.emr.model.InstanceFleetTimeline(
        creationDateTime.map(value => value),
        readyDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def creationDateTime: Optional[Date]
    def readyDateTime: Optional[Date]
    def endDateTime: Optional[Date]
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getReadyDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("readyDateTime", readyDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetTimeline
  ) extends zio.aws.emr.model.InstanceFleetTimeline.ReadOnly {
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val readyDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.readyDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetTimeline
  ): zio.aws.emr.model.InstanceFleetTimeline.ReadOnly = new Wrapper(impl)
}
