package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceFleetType {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceFleetType
}
object InstanceFleetType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceFleetType
  ): zio.aws.emr.model.InstanceFleetType = value match {
    case software.amazon.awssdk.services.emr.model.InstanceFleetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetType.MASTER =>
      val r = MASTER
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetType.CORE =>
      val r = CORE
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetType.TASK =>
      val r = TASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceFleetType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetType =
      software.amazon.awssdk.services.emr.model.InstanceFleetType.UNKNOWN_TO_SDK_VERSION
  }
  case object MASTER extends zio.aws.emr.model.InstanceFleetType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetType =
      software.amazon.awssdk.services.emr.model.InstanceFleetType.MASTER
  }
  case object CORE extends zio.aws.emr.model.InstanceFleetType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetType =
      software.amazon.awssdk.services.emr.model.InstanceFleetType.CORE
  }
  case object TASK extends zio.aws.emr.model.InstanceFleetType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetType =
      software.amazon.awssdk.services.emr.model.InstanceFleetType.TASK
  }
}
