package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceGroupStatus(
    state: Optional[zio.aws.emr.model.InstanceGroupState] = Optional.Absent,
    stateChangeReason: Optional[
      zio.aws.emr.model.InstanceGroupStateChangeReason
    ] = Optional.Absent,
    timeline: Optional[zio.aws.emr.model.InstanceGroupTimeline] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroupStatus = {
    import InstanceGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroupStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroupStatus.ReadOnly =
    zio.aws.emr.model.InstanceGroupStatus.wrap(buildAwsValue())
}
object InstanceGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroupStatus =
      zio.aws.emr.model.InstanceGroupStatus(
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        timeline.map(value => value.asEditable)
      )
    def state: Optional[zio.aws.emr.model.InstanceGroupState]
    def stateChangeReason
        : Optional[zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly]
    def timeline: Optional[zio.aws.emr.model.InstanceGroupTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupStatus
  ) extends zio.aws.emr.model.InstanceGroupStatus.ReadOnly {
    override val state: Optional[zio.aws.emr.model.InstanceGroupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.emr.model.InstanceGroupState.wrap(value))
    override val stateChangeReason
        : Optional[zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeReason())
        .map(value =>
          zio.aws.emr.model.InstanceGroupStateChangeReason.wrap(value)
        )
    override val timeline
        : Optional[zio.aws.emr.model.InstanceGroupTimeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeline())
        .map(value => zio.aws.emr.model.InstanceGroupTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupStatus
  ): zio.aws.emr.model.InstanceGroupStatus.ReadOnly = new Wrapper(impl)
}
