package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  NonNegativeDouble,
  XmlStringMaxLen256,
  WholeNumber,
  InstanceType
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceTypeConfig(
    instanceType: InstanceType,
    weightedCapacity: Optional[WholeNumber] = Optional.Absent,
    bidPrice: Optional[XmlStringMaxLen256] = Optional.Absent,
    bidPriceAsPercentageOfOnDemandPrice: Optional[NonNegativeDouble] =
      Optional.Absent,
    ebsConfiguration: Optional[zio.aws.emr.model.EbsConfiguration] =
      Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    customAmiId: Optional[XmlStringMaxLen256] = Optional.Absent,
    priority: Optional[NonNegativeDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceTypeConfig = {
    import InstanceTypeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceTypeConfig
      .builder()
      .instanceType(InstanceType.unwrap(instanceType): java.lang.String)
      .optionallyWith(
        weightedCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.weightedCapacity)
      .optionallyWith(
        bidPrice.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.bidPrice)
      .optionallyWith(
        bidPriceAsPercentageOfOnDemandPrice.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.bidPriceAsPercentageOfOnDemandPrice)
      .optionallyWith(ebsConfiguration.map(value => value.buildAwsValue()))(
        _.ebsConfiguration
      )
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(
        priority.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceTypeConfig.ReadOnly =
    zio.aws.emr.model.InstanceTypeConfig.wrap(buildAwsValue())
}
object InstanceTypeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceTypeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceTypeConfig =
      zio.aws.emr.model.InstanceTypeConfig(
        instanceType,
        weightedCapacity.map(value => value),
        bidPrice.map(value => value),
        bidPriceAsPercentageOfOnDemandPrice.map(value => value),
        ebsConfiguration.map(value => value.asEditable),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customAmiId.map(value => value),
        priority.map(value => value)
      )
    def instanceType: InstanceType
    def weightedCapacity: Optional[WholeNumber]
    def bidPrice: Optional[XmlStringMaxLen256]
    def bidPriceAsPercentageOfOnDemandPrice: Optional[NonNegativeDouble]
    def ebsConfiguration: Optional[zio.aws.emr.model.EbsConfiguration.ReadOnly]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def customAmiId: Optional[XmlStringMaxLen256]
    def priority: Optional[NonNegativeDouble]
    def getInstanceType: ZIO[Any, Nothing, InstanceType] =
      ZIO.succeed(instanceType)
    def getWeightedCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getBidPrice: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getBidPriceAsPercentageOfOnDemandPrice
        : ZIO[Any, AwsError, NonNegativeDouble] = AwsError.unwrapOptionField(
      "bidPriceAsPercentageOfOnDemandPrice",
      bidPriceAsPercentageOfOnDemandPrice
    )
    def getEbsConfiguration
        : ZIO[Any, AwsError, zio.aws.emr.model.EbsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("ebsConfiguration", ebsConfiguration)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getPriority: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeConfig
  ) extends zio.aws.emr.model.InstanceTypeConfig.ReadOnly {
    override val instanceType: InstanceType =
      zio.aws.emr.model.primitives.InstanceType(impl.instanceType())
    override val weightedCapacity: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.weightedCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val bidPrice: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPrice())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val bidPriceAsPercentageOfOnDemandPrice
        : Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPriceAsPercentageOfOnDemandPrice())
      .map(value => zio.aws.emr.model.primitives.NonNegativeDouble(value))
    override val ebsConfiguration
        : Optional[zio.aws.emr.model.EbsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsConfiguration())
        .map(value => zio.aws.emr.model.EbsConfiguration.wrap(value))
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val customAmiId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val priority: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.emr.model.primitives.NonNegativeDouble(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeConfig
  ): zio.aws.emr.model.InstanceTypeConfig.ReadOnly = new Wrapper(impl)
}
