package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  BooleanObject,
  WholeNumber,
  InstanceType,
  NonNegativeDouble
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceTypeSpecification(
    instanceType: Optional[InstanceType] = Optional.Absent,
    weightedCapacity: Optional[WholeNumber] = Optional.Absent,
    bidPrice: Optional[XmlStringMaxLen256] = Optional.Absent,
    bidPriceAsPercentageOfOnDemandPrice: Optional[NonNegativeDouble] =
      Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    ebsBlockDevices: Optional[Iterable[zio.aws.emr.model.EbsBlockDevice]] =
      Optional.Absent,
    ebsOptimized: Optional[BooleanObject] = Optional.Absent,
    customAmiId: Optional[XmlStringMaxLen256] = Optional.Absent,
    priority: Optional[NonNegativeDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceTypeSpecification = {
    import InstanceTypeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
      .builder()
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        weightedCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.weightedCapacity)
      .optionallyWith(
        bidPrice.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.bidPrice)
      .optionallyWith(
        bidPriceAsPercentageOfOnDemandPrice.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.bidPriceAsPercentageOfOnDemandPrice)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsBlockDevices)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(
        priority.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceTypeSpecification.ReadOnly =
    zio.aws.emr.model.InstanceTypeSpecification.wrap(buildAwsValue())
}
object InstanceTypeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceTypeSpecification =
      zio.aws.emr.model.InstanceTypeSpecification(
        instanceType.map(value => value),
        weightedCapacity.map(value => value),
        bidPrice.map(value => value),
        bidPriceAsPercentageOfOnDemandPrice.map(value => value),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        customAmiId.map(value => value),
        priority.map(value => value)
      )
    def instanceType: Optional[InstanceType]
    def weightedCapacity: Optional[WholeNumber]
    def bidPrice: Optional[XmlStringMaxLen256]
    def bidPriceAsPercentageOfOnDemandPrice: Optional[NonNegativeDouble]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def ebsBlockDevices
        : Optional[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]]
    def ebsOptimized: Optional[BooleanObject]
    def customAmiId: Optional[XmlStringMaxLen256]
    def priority: Optional[NonNegativeDouble]
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getWeightedCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getBidPrice: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getBidPriceAsPercentageOfOnDemandPrice
        : ZIO[Any, AwsError, NonNegativeDouble] = AwsError.unwrapOptionField(
      "bidPriceAsPercentageOfOnDemandPrice",
      bidPriceAsPercentageOfOnDemandPrice
    )
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getEbsBlockDevices
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      AwsError.unwrapOptionField("ebsBlockDevices", ebsBlockDevices)
    def getEbsOptimized: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getPriority: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ) extends zio.aws.emr.model.InstanceTypeSpecification.ReadOnly {
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val weightedCapacity: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.weightedCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val bidPrice: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPrice())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val bidPriceAsPercentageOfOnDemandPrice
        : Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPriceAsPercentageOfOnDemandPrice())
      .map(value => zio.aws.emr.model.primitives.NonNegativeDouble(value))
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val ebsBlockDevices
        : Optional[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsBlockDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.EbsBlockDevice.wrap(item)
          }.toList
        )
    override val ebsOptimized: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: BooleanObject)
    override val customAmiId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val priority: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.emr.model.primitives.NonNegativeDouble(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ): zio.aws.emr.model.InstanceTypeSpecification.ReadOnly = new Wrapper(impl)
}
