package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  Marker,
  InstanceFleetId,
  InstanceGroupId,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInstancesRequest(
    clusterId: ClusterId,
    instanceGroupId: Optional[InstanceGroupId] = Optional.Absent,
    instanceGroupTypes: Optional[
      Iterable[zio.aws.emr.model.InstanceGroupType]
    ] = Optional.Absent,
    instanceFleetId: Optional[InstanceFleetId] = Optional.Absent,
    instanceFleetType: Optional[zio.aws.emr.model.InstanceFleetType] =
      Optional.Absent,
    instanceStates: Optional[Iterable[zio.aws.emr.model.InstanceState]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstancesRequest = {
    import ListInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstancesRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        instanceGroupId.map(value =>
          InstanceGroupId.unwrap(value): java.lang.String
        )
      )(_.instanceGroupId)
      .optionallyWith(
        instanceGroupTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceGroupTypesWithStrings)
      .optionallyWith(
        instanceFleetId.map(value =>
          InstanceFleetId.unwrap(value): java.lang.String
        )
      )(_.instanceFleetId)
      .optionallyWith(instanceFleetType.map(value => value.unwrap))(
        _.instanceFleetType
      )
      .optionallyWith(
        instanceStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceStatesWithStrings)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstancesRequest.ReadOnly =
    zio.aws.emr.model.ListInstancesRequest.wrap(buildAwsValue())
}
object ListInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstancesRequest =
      zio.aws.emr.model.ListInstancesRequest(
        clusterId,
        instanceGroupId.map(value => value),
        instanceGroupTypes.map(value => value),
        instanceFleetId.map(value => value),
        instanceFleetType.map(value => value),
        instanceStates.map(value => value),
        marker.map(value => value)
      )
    def clusterId: ClusterId
    def instanceGroupId: Optional[InstanceGroupId]
    def instanceGroupTypes: Optional[List[zio.aws.emr.model.InstanceGroupType]]
    def instanceFleetId: Optional[InstanceFleetId]
    def instanceFleetType: Optional[zio.aws.emr.model.InstanceFleetType]
    def instanceStates: Optional[List[zio.aws.emr.model.InstanceState]]
    def marker: Optional[Marker]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getInstanceGroupId: ZIO[Any, AwsError, InstanceGroupId] =
      AwsError.unwrapOptionField("instanceGroupId", instanceGroupId)
    def getInstanceGroupTypes
        : ZIO[Any, AwsError, List[zio.aws.emr.model.InstanceGroupType]] =
      AwsError.unwrapOptionField("instanceGroupTypes", instanceGroupTypes)
    def getInstanceFleetId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("instanceFleetId", instanceFleetId)
    def getInstanceFleetType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetType] =
      AwsError.unwrapOptionField("instanceFleetType", instanceFleetType)
    def getInstanceStates
        : ZIO[Any, AwsError, List[zio.aws.emr.model.InstanceState]] =
      AwsError.unwrapOptionField("instanceStates", instanceStates)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstancesRequest
  ) extends zio.aws.emr.model.ListInstancesRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val instanceGroupId: Optional[InstanceGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroupId())
        .map(value => zio.aws.emr.model.primitives.InstanceGroupId(value))
    override val instanceGroupTypes
        : Optional[List[zio.aws.emr.model.InstanceGroupType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroupTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceGroupType.wrap(item)
          }.toList
        )
    override val instanceFleetId: Optional[InstanceFleetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFleetId())
        .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val instanceFleetType
        : Optional[zio.aws.emr.model.InstanceFleetType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFleetType())
      .map(value => zio.aws.emr.model.InstanceFleetType.wrap(value))
    override val instanceStates
        : Optional[List[zio.aws.emr.model.InstanceState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceState.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstancesRequest
  ): zio.aws.emr.model.ListInstancesRequest.ReadOnly = new Wrapper(impl)
}
