package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.MaxResultsNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReleaseLabelsRequest(
    filters: Optional[zio.aws.emr.model.ReleaseLabelFilter] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest = {
    import ListReleaseLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsNumber.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListReleaseLabelsRequest.ReadOnly =
    zio.aws.emr.model.ListReleaseLabelsRequest.wrap(buildAwsValue())
}
object ListReleaseLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListReleaseLabelsRequest =
      zio.aws.emr.model.ListReleaseLabelsRequest(
        filters.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[zio.aws.emr.model.ReleaseLabelFilter.ReadOnly]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsNumber]
    def getFilters
        : ZIO[Any, AwsError, zio.aws.emr.model.ReleaseLabelFilter.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsNumber] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest
  ) extends zio.aws.emr.model.ListReleaseLabelsRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.emr.model.ReleaseLabelFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.emr.model.ReleaseLabelFilter.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.emr.model.primitives.MaxResultsNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest
  ): zio.aws.emr.model.ListReleaseLabelsRequest.ReadOnly = new Wrapper(impl)
}
