package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Marker, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStudioSessionMappingsRequest(
    studioId: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityType: Optional[zio.aws.emr.model.IdentityType] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest = {
    import ListStudioSessionMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudioSessionMappingsRequest.ReadOnly =
    zio.aws.emr.model.ListStudioSessionMappingsRequest.wrap(buildAwsValue())
}
object ListStudioSessionMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudioSessionMappingsRequest =
      zio.aws.emr.model.ListStudioSessionMappingsRequest(
        studioId.map(value => value),
        identityType.map(value => value),
        marker.map(value => value)
      )
    def studioId: Optional[XmlStringMaxLen256]
    def identityType: Optional[zio.aws.emr.model.IdentityType]
    def marker: Optional[Marker]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getIdentityType: ZIO[Any, AwsError, zio.aws.emr.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest
  ) extends zio.aws.emr.model.ListStudioSessionMappingsRequest.ReadOnly {
    override val studioId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityType: Optional[zio.aws.emr.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.emr.model.IdentityType.wrap(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest
  ): zio.aws.emr.model.ListStudioSessionMappingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
